p = 4;
iterations = 30;
r_0 = (p - 2)./(p - 1);
%r_opt = 0.754877666246692;
%r_opt = 0.921599319633983;
%r_opt = 0.992987612282951;
y = [r_0];
y_opt = [r_opt];
r = r_0;

for k = 1:iterations
    r = test(r, p);
    y = [y, r];
    y_opt = [y_opt, r_opt];
end

x = 0:iterations;
plot(x, y, 'r-*','LineWidth',5);
hold on
plot(x, y_opt, 'b','LineWidth',5);
set(gcf,'position',[0,0,600,500])
set(gca,'FontSize', 20, 'fontweight','bold')
legend({'$r_k$', '$r_*$'}, 'Interpreter','latex','fontsize', 60, 'location', 'southeast')
xlabel('\textbf{Number of Iteration} ${\boldmath{k}}$','Interpreter','latex','fontsize',40)
grid on
grid minor
hold off